<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;



class District extends Model
{
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $table = 'district';


    public function donors()
        {
            return $this->hasMany(Donor::class, 'district_id', 'id');
        }
        
        
        public function applicant()
    {
        return $this->hasMany(Applicant::class, 'district_id', 'id');
    }
   
}
