@extends('layout')

@section('main_title','Donors')
@section('title','Donors')
@section('breadcrumb','Donors')

@section('content')

<div class="row">
                     <div class="col-12">
                        <div class="card">
                           <div class="card-header">
                              <h3 class="card-title">Supporter Insights - Donor Analytics</h3>
                              <button type="button" class="btn btn-primary btn-sm" style="border-radius:25px">Add Donor</button>
                           </div>
                           <!-- /.card-header -->
                           <div class="card-body">
                              <table id="example1" class="table table-bordered table-striped">
                                 <thead>
                                    <tr>
                                       <th>Sl.No</th>
                                       <th>Donor Details</th>
                                       <th>Amount</th>
                                       <th>Mode</th>
                                       <th>Payment Details</th>
                                       <th>Dates</th>
                                       <th width="25%">Action</th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    
                                        @php
                                        $sn=1;
                                        @endphp
                                        
                                        @foreach($donors as $donor)
                                        <tr>
                                           <td>{{$sn++}}</td>
                                           <td>{{$donor->first_name}}{{$donor->last_name}}<br><small>{{$donor->company_name}}<br>{{$donor->city->name}}, {{$donor->state->state_title}}</small></td>
                                           
                                           <td>&#8377; 
                                           @if(!empty($donor->payment))
                                           @foreach($donor->payment as $pay)
                                           {{$pay->amount}}
                                            @endforeach 
                                           @endif
                                           </td>
                                           <td>
                                                @if(!empty($donor->payment))
                                                @foreach($donor->payment as $pay)
                                                 {{$pay->payer_type}}
                                                 @endforeach 
                                               @endif
                                               </td>
                                           <td> @if(!empty($donor->payment))
                                           @foreach($donor->payment as $pay)
                                            {{$pay->payment_mode}}<br><small>{{$pay->cheque_number}}<br></small>{{$pay->cheque_bank}}
                                           @endforeach
                                           @endif
                                              </td>
                                           <td>
                                               @if(!empty($donor->payment))
                                               @foreach($donor->payment as $pay)
                                               {{$pay->cheque_date}}
                                               @endforeach
                                               @endif
                                                </td>
                                           <td>
    											<button type="button" class="btn btn-success btn-sm">View Payment </button>
    											<button type="button" class="btn btn-primary btn-sm">View Photos </button>
    											<br>
    											<a href="" class="btn btn-info btn-sm">Edit</a>
    											<a href=""  class="btn btn-warning btn-sm">View Tax Certificate  </a>
    										</td>
    									</tr>
										@endforeach
                                    
                                    
                                    
                                 </tbody>
                                 <tfoot>
                                    <tr>
                                       <th>Sl.No</th>
                                       <th>Donor Details</th>
                                       <th>Amount</th>
                                       <th>Mode</th>
                                       <th>Payment Details</th>
                                       <th>Dates</th>
                                       <th>Action</th>
                                    </tr>
                                 </tfoot>
                              </table>
                           </div>
                           <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                     </div>
                     <!-- /.col -->
                  </div>

@endsection